*Elaborado por Rita Ricaldi.  Actualizado:10/12/2007.

*----------------------------------------------CONFIGURA PATHS------------------------------------*.
FILE HANDLE DATOS /NAME='Z:\_CENAN\00 MONIN\01 Programas\98 Weight'

*----------------------------------------------------------------------------------------------------------------*.
*    Importa del archivo excel los datos del diseno muestral 1996-2001             *.
*----------------------------------------------------------------------------------------------------------------*.

GET DATA /TYPE=XLS
   /FILE='DATOS\pSeleCongINEI.xls'
   /SHEET=name 'bdCong'
   /CELLRANGE=full
   /READNAMES=on
   /ASSUMEDSTRWIDTH=32767.
Vari label
id_enc  'Id Encuesta'
NroCong 'id Conglomerado'
Numero '[no documentado]'
ambito 'Dominio'
Bolsa '[no documentado]'
Tamano ' Tamano del conglomerado(# viviendas) segun el marco muestral'
nViv '# Viviendas en el estrato segun el marco censal [por verificar]'
nCon '# de conglomerados seleccionados en el estrato [por verificar]'
Prob 'Probabilidad de seleccion del conglomerado dentro del estrato [por verificar]'.
Value label 
id_enc 
1 '1996'
2 '1997'
3 '1998'
4 '1999'
5 '2000'
6 '2001'
7 '2002'
8 '2003'
9 '2004'
10 '2006'.
Valu label
ambito
1 'Costa '
2 'Sierra Urbana'
3 'Sierra Rural'
4 'Selva'
5 'Lima Metropolitana'
6 'Trapecio Andino'.

*Pareceria ser que Prob es igual: .
*Prob=nCon/(nViv/Tamano).
*Donde:.
*Prob=Probabilidad de seleccion del conglomerado dentro del estrato(i) [los datos asi lo sugieren].
*nCon= # Conglomerados seleccionados en el estrato(i)
*nViv= # Viviendas en el estrato(i) segun el marco censal
*tamano= Total de viviendas del conglomerado (tamano del conglomerado).

Compute Muestreo=1.
if (id_enc>6) Muestreo=2.
Vari label Muestreo 'Tipo de muestreo'
valu label muestreo 1'Seis estratos' 2'Departamental'.

*>> se agrega el total de estratos en cada una de las encuestas.
compute x=1/nCon.
execute.
AGGREGATE
  /OUTFILE=*
  MODE=ADDVARIABLES
  /BREAK=id_Enc
  /nEstrato '# Estratos' = SUM(x).
FORMAT nEstrato (f2.0).
*>> se agrega el total de viviendas Pais en cada uno de las encuestas.
*>> idealmente deberia ser el igual al marco muestral proyectado para el ano de la encuesta.
compute x=nViv/nCon.
execute.
AGGREGATE
  /OUTFILE=*
  MODE=ADDVARIABLES
  /BREAK=id_Enc
  /nVivPeru '# Viviendas Peru' = SUM(x).
FORMAT nVivPeru (f9.0).
DELE VARI X.
EXECUTE.

*>> Probabilidad de seleccion de una vivienda en el conglomerado(i).
*>> Siendo 10 el numero de viviendas a seleccionar por hogar.
compute Prob1= 10/tamano.
execute.
FORMAT Prob1 (f9.7).
VARI LABEL  Prob1 'Probabilidad de seleccion del hogar dentro del conglomerado'.

*>>Design Weight .
compute F0= 1/(Prob*Prob1).
execute.
VARI LABEL F0 'Factor expansion hogar sin ajuste'.

SAVE OUTFILE='DATOS\00DisenoMuestra.SAV'.


 




